using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web.Mvc;

namespace HIPS.Web.UI.ViewModels.HpiiSearch
{
    public class AustralianAddressViewModel : IValidatableObject
    {
        [Display(Name = "Unit Type")]
        public string UnitTypeCode { get; set; }

        [Display(Name = "Unit Number")]
        [StringLength(6, ErrorMessage = "Unit Number must be less than 6 characters long.")]
        public string UnitNumber { get; set; }

        [Display(Name = "Site/Building Name")]
        [StringLength(30, ErrorMessage = "Site/Building Name must be less than 30 characters long.")]
        public string SiteName { get; set; }

        [Display(Name = "Level Type")]
        public string LevelTypeCode { get; set; }

        [Display(Name = "Level Number")]
        [StringLength(30, ErrorMessage = "Level Number must be less than 30 characters long.")]
        public string LevelNumber { get; set; }

        [Display(Name = "Street Number")]
        [StringLength(12, ErrorMessage = "Street Number must be less than 12 characters long.")]
        public string StreetNumber { get; set; }

        [Display(Name = "Lot Number")]
        [StringLength(15, ErrorMessage = "Lot Number must be less than 15 characters long.")]
        public string LotNumber { get; set; }

        [Display(Name = "Street Name")]
        [StringLength(30, ErrorMessage = "Street Name must be less than 30 characters long.")]
        public string StreetName { get; set; }

        [Display(Name = "Street Type")]
        public string StreetTypeCode { get; set; }

        [Display(Name = "Street Suffix")]
        public string StreetSuffixCode { get; set; }

        [Display(Name = "Postal Delivery Type")]
        public string PostalDeliveryTypeCode { get; set; }

        [Display(Name = "Postal Delivery Number")]
        [StringLength(11, ErrorMessage = "Postal Delivery Number must be less than 11 characters long.")]
        public string PostalDeliveryNumber { get; set; }

        [Display(Name = "Suburb")]
        [StringLength(50, ErrorMessage = "Suburb must be less than 50 characters long.")]
        public string Suburb { get; set; }

        [Display(Name = "State")]
        public string StateCode { get; set; }

        [Display(Name = "Postcode")]
        [StringLength(4, ErrorMessage = "Postcode must be less than 4 characters long.")]
        public string Postcode { get; set; }

        #region Data Source Properties

        public IEnumerable<SelectListItem> UnitTypes { get; internal set; }
        public IEnumerable<SelectListItem> LevelTypes { get; internal set; }
        public IEnumerable<SelectListItem> StreetTypes { get; internal set; }
        public IEnumerable<SelectListItem> StreetSuffixes { get; internal set; }
        public IEnumerable<SelectListItem> PostalDeliveryTypes { get; internal set; }
        public IEnumerable<SelectListItem> States { get; internal set; }

        #endregion

        public AustralianAddressViewModel()
        {
            UnitTypes = Enumerable.Empty<SelectListItem>();
            LevelTypes = Enumerable.Empty<SelectListItem>();
            StreetTypes = Enumerable.Empty<SelectListItem>();
            StreetSuffixes = Enumerable.Empty<SelectListItem>();
            PostalDeliveryTypes = Enumerable.Empty<SelectListItem>();
            States = Enumerable.Empty<SelectListItem>();
        }

        public bool HasAnyValue()
        {
            return new[] { 
                UnitTypeCode, 
                UnitNumber, 
                SiteName,
                LevelTypeCode, 
                LevelNumber,
                StreetNumber,
                LotNumber,
                StreetName,
                StreetTypeCode,
                StreetSuffixCode,
                PostalDeliveryTypeCode,
                PostalDeliveryNumber,
                Suburb,
                StateCode,
                Postcode
            }.Any(s => !String.IsNullOrEmpty(s));
        }

        /// <summary>
        ///     Determines whether the specified object is valid.
        /// </summary>
        /// <returns>
        ///     A collection that holds failed-validation information.
        /// </returns>
        /// <param name="validationContext">The validation context.</param>
        /// <remarks>
        ///     Executed server-side after all annotation validators are successful.
        /// </remarks>
        public IEnumerable<ValidationResult> Validate(ValidationContext validationContext)
        {
            List<ValidationResult> errors = new List<ValidationResult>();

            if (this.HasAnyValue())
            {
                if (String.IsNullOrWhiteSpace(Suburb))
                {
                    errors.Add(new ValidationResult("Please provide a Suburb for the Australian Address."));
                }

                if (String.IsNullOrWhiteSpace(Postcode))
                {
                    errors.Add(new ValidationResult("Please provide a Postcode for the Australian Address."));
                }

                if (String.IsNullOrWhiteSpace(StateCode))
                {
                    errors.Add(new ValidationResult("Please provide a State for the Australian Address."));
                }
            }

            return errors;
        }
    }
}